module My_RPG


  class My_Troop < RPG::Troop
    class My_Page < RPG::Troop::Page

      include My_DB_Text
      include Module_Page

      attr_reader :indents

      attr_accessor :lieu

      def initialize
        @condition = My_RPG::My_Troop::My_Page::My_Condition.new
        @span = 0
        @list = []
        @indents = {}
      end


      def to_rmxp
        page = self.cast(RPG::Troop::Page)

        page.list = []

        #list = separer_instructions(self.instructions.clone)
        list = self.instructions

        for i in 0...list.size
          rmxp = list[i].to_rmxp
          if rmxp.is_a?(Array) == false
            page.list << rmxp
          else
            # AMELIORER CONCAT
            page.list = page.list.concat(rmxp)
          end
        end
        return page
      end

      def numero
        return self.troop.pages.index(self)
      end

      def position
        return "#{self.troop.numero}:#{self.numero}"
      end

      def exporter_dialogue
      
        return super("PAGE", "Troop", true)

      end


      def troop=(new_troop)
        @lieu = new_troop
      end

      def troop
        return @lieu
      end


      def get_position_str(pos)
        return sprintf("[Troop:%d:%d:%d]", self.troop.numero, self.numero, pos)
      end




    end

  end
end
